=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Copyright © 2008-2016 - Designed and written as of Dec 2008 by Fredo6
#
# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   Fredo6_!LibFredo6.rb
# Original Date	:   20 Aug 2008 - version 3.0
# Type			:   Ruby Library
# Description	:   Top loading module for all Library utilities of Fredo6's scripts
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

unless defined?(LibFredo6_Loader)

	require 'sketchup.rb'
	require 'extensions.rb'
	
	module LibFredo6_Loader

	def LibFredo6_Loader.time_loaded
		@time_loaded
	end
	
	#Method to register the LibFredo6 extension
	def self.register_extension(hsh_ext)
		ext = SketchupExtension.new hsh_ext[:name], hsh_ext[:floader]
		ext.creator = hsh_ext[:creator] 
		ext.description = hsh_ext[:description] 
		ext.version = hsh_ext[:version] 
		ext.copyright = hsh_ext[:copyright] 	
		status = Sketchup.register_extension ext, true
	end

	#Top processing method
	def self.process
		#Account for non-ascii characters in the path
		file__ = __FILE__
		file__ = file__.force_encoding("UTF-8") if defined?(Encoding)
		f6__file__ = file__.gsub(/\\/, '/')
		f6__sudir = File.dirname(f6__file__)
		
		#Finding the loader file in LibFredo6 folder and loading it
		folder = File.join(f6__sudir, "Fredo6_!LibFredo6", "top_LibFredo6")
		file_encrypted = (Sketchup.version.to_i >= 16) ? folder + ".rbe" : folder + ".rbs"	
		file_to_load = file_encrypted
		file_to_load = folder + ".rb" unless FileTest.exist?(file_to_load)
		if FileTest.exist?(file_to_load)
			if (Sketchup.version.to_i <= 13) && FileTest.exist?(file_encrypted)
				eval("Sketchup.require \"#{file_to_load}\"", TOPLEVEL_BINDING)
			else	
				Sketchup.require file_to_load
			end	
			LibFredo6.startup(f6__sudir) { |hsh_ext| register_extension(hsh_ext) }
		else
			UI.messagebox "Wrong installation: Folder Fredo6_!LibFredo6 is missing in #{f6__sudir}"
		end
	end

	#Processing with the load
	process
			
	#Registering the time after load
	@time_loaded = Time.now
	
	end	#Module LibFredo6_Loader

#The module has already been loaded
else 
	UI.messagebox "LibFredo6 already installed\nIt will be updated at next startup of Sketchup" if (Time.now - LibFredo6_Loader.time_loaded) > 30
	
end	#defined?(LibFredo6_Loader)